/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.tom.storagemod.block.BlockInventoryCable;
import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.proxy.ClientProxy;
import com.tom.storagemod.tile.TileEntityInventoryCableConnectorFiltered;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class BlockInventoryCableConnectorFiltered
extends ContainerBlock
implements IInventoryCable {
    public static final BooleanProperty UP = BlockStateProperties.field_208149_B;
    public static final BooleanProperty DOWN = BlockStateProperties.field_208150_C;
    public static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    public static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    public static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    public static final BooleanProperty WEST = BlockStateProperties.field_208154_G;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final Direction[] FACING_VALUES = Direction.values();
    protected VoxelShape[][] shapes;

    public BlockInventoryCableConnectorFiltered() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(3.0f).func_226896_b_().harvestTool(ToolType.AXE));
        this.setRegistryName("ts.inventory_cable_connector_filtered");
        this.shapes = this.makeShapes(0.125f);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.DOWN));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.toms_storage.filtered"));
        ClientProxy.tooltip("inventory_cable_connector", tooltip);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityInventoryCableConnectorFiltered();
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST, FACING});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction f = (Direction)stateIn.func_177229_b((Property)FACING);
        if (facing == f) {
            return (BlockState)stateIn.func_206870_a((Property)SixWayBlock.field_196491_B.get(facing), (Comparable)Boolean.valueOf(!facingState.isAir((IBlockReader)worldIn, facingPos)));
        }
        return (BlockState)stateIn.func_206870_a((Property)SixWayBlock.field_196491_B.get(facing), (Comparable)Boolean.valueOf(IInventoryCable.canConnect(facingState, facing)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.withConnectionProperties((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l().func_176734_d()), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    @Override
    public boolean canConnectFrom(BlockState state, Direction dir) {
        return state.func_177229_b((Property)FACING) != dir;
    }

    @Override
    public List<BlockPos> next(World world, BlockState state, BlockPos pos) {
        Direction f = (Direction)state.func_177229_b((Property)FACING);
        ArrayList<BlockPos> next = new ArrayList<BlockPos>();
        for (Direction d : Direction.values()) {
            if (d == f || !((Boolean)state.func_177229_b((Property)BlockInventoryCable.DIR_TO_PROPERTY[d.ordinal()])).booleanValue()) continue;
            next.add(pos.func_177972_a(d));
        }
        return next;
    }

    public BlockState withConnectionProperties(BlockState state, IWorld blockView_1, BlockPos blockPos_1) {
        BlockState block_1 = blockView_1.func_180495_p(blockPos_1.func_177977_b());
        BlockState block_2 = blockView_1.func_180495_p(blockPos_1.func_177984_a());
        BlockState block_3 = blockView_1.func_180495_p(blockPos_1.func_177978_c());
        BlockState block_4 = blockView_1.func_180495_p(blockPos_1.func_177974_f());
        BlockState block_5 = blockView_1.func_180495_p(blockPos_1.func_177968_d());
        BlockState block_6 = blockView_1.func_180495_p(blockPos_1.func_177976_e());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(this.canConnect(state, block_1, Direction.DOWN)))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(this.canConnect(state, block_2, Direction.UP)))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(state, block_3, Direction.NORTH)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(state, block_4, Direction.EAST)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(state, block_5, Direction.SOUTH)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(state, block_6, Direction.WEST)));
    }

    private boolean canConnect(BlockState state, BlockState block, Direction dir) {
        Direction f = (Direction)state.func_177229_b((Property)FACING);
        return dir != f && IInventoryCable.canConnect(block, dir) || dir == f && !block.func_196958_f();
    }

    public BlockState func_185499_a(BlockState blockState_1, Rotation blockRotation_1) {
        switch (blockRotation_1) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState_1.func_206870_a((Property)NORTH, blockState_1.func_177229_b((Property)SOUTH))).func_206870_a((Property)EAST, blockState_1.func_177229_b((Property)WEST))).func_206870_a((Property)SOUTH, blockState_1.func_177229_b((Property)NORTH))).func_206870_a((Property)WEST, blockState_1.func_177229_b((Property)EAST));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState_1.func_206870_a((Property)NORTH, blockState_1.func_177229_b((Property)EAST))).func_206870_a((Property)EAST, blockState_1.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, blockState_1.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, blockState_1.func_177229_b((Property)NORTH));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState_1.func_206870_a((Property)NORTH, blockState_1.func_177229_b((Property)WEST))).func_206870_a((Property)EAST, blockState_1.func_177229_b((Property)NORTH))).func_206870_a((Property)SOUTH, blockState_1.func_177229_b((Property)EAST))).func_206870_a((Property)WEST, blockState_1.func_177229_b((Property)SOUTH));
            }
        }
        return blockState_1;
    }

    public BlockState func_185471_a(BlockState blockState_1, Mirror blockMirror_1) {
        switch (blockMirror_1) {
            case FRONT_BACK: {
                return (BlockState)((BlockState)blockState_1.func_206870_a((Property)NORTH, blockState_1.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, blockState_1.func_177229_b((Property)NORTH));
            }
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)blockState_1.func_206870_a((Property)EAST, blockState_1.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, blockState_1.func_177229_b((Property)EAST));
            }
        }
        return super.func_185471_a(blockState_1, blockMirror_1);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[((Direction)state.func_177229_b((Property)FACING)).ordinal()][this.getShapeIndex(state)];
    }

    protected int getShapeIndex(BlockState state) {
        int i = 0;
        for (int j = 0; j < FACING_VALUES.length; ++j) {
            if (!((Boolean)state.func_177229_b((Property)SixWayBlock.field_196491_B.get(FACING_VALUES[j]))).booleanValue()) continue;
            i |= 1 << j;
        }
        return i;
    }

    private VoxelShape[][] makeShapes(float apothem) {
        float f = 0.5f - apothem;
        float f1 = 0.5f + apothem;
        VoxelShape voxelshape = Block.func_208617_a((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f));
        VoxelShape[] avoxelshape = new VoxelShape[FACING_VALUES.length];
        for (int i = 0; i < FACING_VALUES.length; ++i) {
            Direction direction = FACING_VALUES[i];
            avoxelshape[i] = VoxelShapes.func_197873_a((double)(0.5 + Math.min((double)(-apothem), (double)direction.func_82601_c() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.func_96559_d() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.func_82599_e() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.func_82601_c() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.func_96559_d() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.func_82599_e() * 0.5)));
        }
        VoxelShape[] avoxelshape1 = new VoxelShape[64];
        for (int k = 0; k < 64; ++k) {
            VoxelShape voxelshape1 = voxelshape;
            for (int j = 0; j < FACING_VALUES.length; ++j) {
                if ((k & 1 << j) == 0) continue;
                voxelshape1 = VoxelShapes.func_197872_a((VoxelShape)voxelshape1, (VoxelShape)avoxelshape[j]);
            }
            avoxelshape1[k] = voxelshape1;
        }
        VoxelShape[][] ret = new VoxelShape[6][64];
        for (int i = 0; i < FACING_VALUES.length; ++i) {
            Direction direction = FACING_VALUES[i];
            VoxelShape s = VoxelShapes.func_216384_a((VoxelShape)BlockInventoryCableConnectorFiltered.createShape(direction, 16.0f, 0.0f, 16.0f, 0.0f, 2.0f, 0.0f), (VoxelShape[])new VoxelShape[]{BlockInventoryCableConnectorFiltered.createShape(direction, 10.0f, 3.0f, 10.0f, 3.0f, 2.0f, 2.0f), BlockInventoryCableConnectorFiltered.createShape(direction, 6.0f, 5.0f, 6.0f, 5.0f, 2.0f, 4.0f)});
            for (int j = 0; j < avoxelshape1.length; ++j) {
                ret[i][j] = VoxelShapes.func_197872_a((VoxelShape)avoxelshape1[j], (VoxelShape)s);
            }
        }
        return ret;
    }

    private static VoxelShape createShape(Direction dir, float width, float widthoff, float height, float heightoff, float depth, float depthoff) {
        switch (dir) {
            case DOWN: {
                return Block.func_208617_a((double)heightoff, (double)depthoff, (double)widthoff, (double)(height + heightoff), (double)(depth + depthoff), (double)(width + widthoff));
            }
            case EAST: {
                return Block.func_208617_a((double)(16.0f - depth), (double)heightoff, (double)widthoff, (double)(16.0f - depthoff), (double)(height + heightoff), (double)(width + widthoff));
            }
            case NORTH: {
                return Block.func_208617_a((double)widthoff, (double)heightoff, (double)depthoff, (double)(width + widthoff), (double)(height + heightoff), (double)(depth + depthoff));
            }
            case SOUTH: {
                return Block.func_208617_a((double)widthoff, (double)heightoff, (double)(16.0f - depth), (double)(width + widthoff), (double)(height + heightoff), (double)(16.0f - depthoff));
            }
            case UP: {
                return Block.func_208617_a((double)heightoff, (double)(16.0f - depth), (double)widthoff, (double)(height + heightoff), (double)(16.0f - depthoff), (double)(width + widthoff));
            }
            case WEST: {
                return Block.func_208617_a((double)depthoff, (double)heightoff, (double)widthoff, (double)(depth + depthoff), (double)(height + heightoff), (double)(width + widthoff));
            }
        }
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity blockEntity_1 = world.func_175625_s(pos);
        if (blockEntity_1 instanceof INamedContainerProvider) {
            player.func_213829_a((INamedContainerProvider)blockEntity_1);
        }
        return ActionResultType.SUCCESS;
    }
}

